/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.DeathAnimation;
import Entity.Enemies.Bandit;
import Entity.Enemy;
import Entity.Gate;
import Entity.HUD;
import Entity.Player;
import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;

public class Level1State
extends GameState {
    private TileMap tileMap;
    private Background bg;
    private Player player;
    private HUD hud;
    private int totalScore;
    private boolean open = false;
    private boolean test = false;
    private Gate exit;
    private ArrayList<Enemy> enemies;
    private ArrayList<DeathAnimation> deathAnimations;

    public Level1State(GameStateManager gsm) {
        this.gsm = gsm;
        this.init();
    }

    @Override
    public void init() {
        this.tileMap = new TileMap(30);
        this.tileMap.loadTiles("/Tilesets/forest.png");
        this.tileMap.loadMap("/Levels/level1.map");
        this.tileMap.setPosition(0.0, 0.0);
        this.tileMap.setTween(0.07);
        this.bg = new Background("/Backgrounds/lvbg.png", 0.1);
        this.exit = new Gate(this.tileMap);
        this.exit.setPosition(1845.0, 214.0);
        this.player = new Player(this.tileMap);
        this.player.setScore(this.gsm.getTotal());
        this.player.setPosition(100.0, 100.0);
        this.populateEnemies();
        this.deathAnimations = new ArrayList();
        this.hud = new HUD(this.player);
    }

    public void populateEnemies() {
        this.enemies = new ArrayList();
        Point[] points = new Point[]{new Point(600, 100), new Point(1100, 100), new Point(1300, 100), new Point(1800, 100)};
        int i = 0;
        while (i < points.length) {
            Bandit b = new Bandit(this.tileMap);
            b.setPosition(points[i].x, points[i].y);
            this.enemies.add(b);
            ++i;
        }
    }

    @Override
    public void update() {
        this.exit.update();
        this.player.update();
        this.tileMap.setPosition(160 - this.player.getx(), 120 - this.player.gety());
        this.bg.setPosition(this.tileMap.getx(), this.tileMap.gety());
        this.player.checkAttack(this.enemies);
        this.open = this.exit.checkContact(this.player);
        int i = 0;
        while (i < this.enemies.size()) {
            Enemy e = this.enemies.get(i);
            e.update();
            if (e.isDead()) {
                this.enemies.remove(i);
                --i;
                this.player.setScore(this.player.getScore() + 10);
                this.gsm.setTotal(this.player.getScore());
                this.deathAnimations.add(new DeathAnimation(this.tileMap, e.getx(), e.gety()));
            }
            ++i;
        }
        i = 0;
        while (i < this.deathAnimations.size()) {
            this.deathAnimations.get(i).update();
            if (this.deathAnimations.get(i).shouldRemove()) {
                this.deathAnimations.remove(i);
                --i;
            }
            ++i;
        }
        if (this.player.gety() > 490) {
            this.player.setHealth(this.player.getHealth() - 1);
            this.player.setPosition(100.0, 100.0);
        }
        if (this.player.getHealth() == 0) {
            this.player.reset();
            this.gsm.setState(2);
        }
        if (this.open) {
            this.gsm.setTotal(this.gsm.getTotal());
            this.gsm.setState(4);
            this.gsm.update();
        }
    }

    @Override
    public void draw(Graphics2D graphics) {
        this.bg.draw(graphics);
        this.tileMap.draw(graphics);
        this.exit.draw(graphics);
        this.player.draw(graphics);
        int i = 0;
        while (i < this.enemies.size()) {
            this.enemies.get(i).draw(graphics);
            ++i;
        }
        i = 0;
        while (i < this.deathAnimations.size()) {
            this.deathAnimations.get(i).setMapPosition((int)this.tileMap.getx(), (int)this.tileMap.gety());
            this.deathAnimations.get(i).draw(graphics);
            ++i;
        }
        this.hud.draw(graphics);
    }

    @Override
    public void keyPressed(int k) {
        if (k == 37) {
            this.player.setLeft(true);
        }
        if (k == 39) {
            this.player.setRight(true);
        }
        if (k == 38) {
            this.player.setUp(true);
        }
        if (k == 40) {
            this.player.setDown(true);
        }
        if (k == 65) {
            this.player.setStabbing();
        }
        if (k == 32) {
            this.player.setJumping(true);
        }
    }

    @Override
    public void keyReleased(int k) {
        if (k == 37) {
            this.player.setLeft(false);
        }
        if (k == 39) {
            this.player.setRight(false);
        }
        if (k == 38) {
            this.player.setUp(false);
        }
        if (k == 40) {
            this.player.setDown(false);
        }
        if (k == 87) {
            this.player.setJumping(false);
        }
    }
}

